# Man in the middle consideration

web -> server -> native client
                      ^
                      |
             Could be a fake pretending to be a real one and send emails on behalf of the user

While we are using a TLS connection with self-signed keys, all
the content is encrypted with the PGP keys of the user. Biggest issue would be
a fake native client trying to send fake mails on behalf
of the user by using the EWS access token.

These fake clients could be either:

1. A website open by the user on a seperate tab. This is prevented by the usage
   of CORS with a same-origin policy. The brower will prevent to run fetch() and
   XMLHttpRequest against gpgol-server if the website running that code is not
   also served by gpgol-server.

   See https://developer.mozilla.org/en-US/docs/Web/HTTP/Guides/CORS

   This assume the user didn't install a web addons which are explicitely marked
   as dangerous and for development only for Firefox/Chrome to disable CORS.

2. A malicious native process running on the same machine as gpgol-client. They
   could pretend to be a normal gpgol-client and register themselve as a
   legitimate client and wait for the web client to send the EWS token.

   This is prevented by having the user manually accept every new device which
   connects to gpgol-server and for which the device id is not yet known. This
   process is documented in doc/communication.md (register and connection section)

   In theory, a malicious native client could read the device id from the file
   storage but in that case it's already game over.
