# MIME format sent

Due to limitation in Outlook, the MIME structure sent by outlook is different
to the one created by us.

## OpenPGP

For OpenPGP emails, `multipart/encrypted` is replaced by multipart/mixed.

We inject also a small `text/plain` in the `multipart/mixed` which will be
displayed in Outlook and other webmails like gmail/fastmail as fallback and
giving some instructions to the user.

### Example OpenPGP Encrypted

```
From: Berta Boss <berta.boss@demo.gnupg.com>
To: Berta Boss <berta.boss@demo.gnupg.com>
Subject: Hello
Date: Tue, 27 Feb 2024 16:08:01 +0000
Content-Type: multipart/mixed; boundary="_003_2155521oMNUckLgytfedora_"
MIME-Version: 1.0


--_003_2155521oMNUckLgytfedora_
Content-Type: text/plain; charset="iso-8859-1"
Content-Transfer-Encoding: quoted-printable

This message is encrypted with OpenPGP and need to be opened in a compatibl=
e client. For example: GPG4Win, KMail, Kleopatra or Thunderbird=

--_003_2155521oMNUckLgytfedora_
Content-Type: application/pgp-encrypted; name="ATT00001"
Content-Description: ATT00001
Content-Disposition: attachment; filename="ATT00001"; size=300;
	creation-date="Thu, 29 Feb 2024 13:30:24 GMT";
	modification-date="Wed, 14 Aug 2024 13:45:52 GMT"
Content-ID: <73584D3936AF814E984C1FD7AFAA7C66@eurprd05.prod.outlook.com>
Content-Transfer-Encoding: base64

VmVyc2lvbjogMQ==

--_003_2155521oMNUckLgytfedora_
Content-Type: application/octet-stream; name="msg.asc"
Content-Description: msg.asc
Content-Disposition: attachment; filename="msg.asc"; size=1483;
	creation-date="Thu, 29 Feb 2024 13:30:24 GMT";
	modification-date="Wed, 14 Aug 2024 13:45:52 GMT"
Content-ID: <55247E14FAC53D4DA8B97F6FEA0CA9F3@eurprd05.prod.outlook.com>
Content-Transfer-Encoding: base64

LS0tLS1CRUdJTiBQR1AgTUVTU0FHRS0tLS0tDQoNCmhKNEQvNkw4eXk3RmlmZ1NBd01FTVQyaEQw
WXl0RlZxTUlTMnVNM05kL2JCQWVvdWNYUmtLN3VpRXVWQUc1R2kNCnhpRzRhNkdHcXp5UWNxVE04
....

--_003_2155521oMNUckLgytfedora_--
```

#### OpenPGP Signed

For signed message, `multipart/signed` is sent fine and is not transformed by
Outlook, so we sent a standard compliant signed email.

## S/MIME

For S/MIME emails, while Outlook does support S/MIME emails without issues, it
also doesn't let us as an Outlook extension to be able to read the email. So we
need to embeed the encrypted part inside a multipart/mixed, to not let outlook
recognize the email as S/MIME encrypted.

### Example S/MIME encrypted

```
From: Berta Boss <berta.boss@demo.gnupg.com>
To: Berta Boss <berta.boss@demo.gnupg.com>
Subject: Hello
Date: Tue, 27 Feb 2024 16:08:01 +0000
Content-Type: multipart/mixed; boundary="_002_2120949oMNUckLgytfedora_"
MIME-Version: 1.0

--_002_2120949oMNUckLgytfedora_
Content-Type: text/plain; charset="iso-8859-1"
Content-Transfer-Encoding: quoted-printable

This message is encrypted with S/MIME and need to be opened in a compatible=
 client. For example: GPG4Win, KMail, Kleopatra or Thunderbird=

--_002_2120949oMNUckLgytfedora_
Content-Type: application/pkcs7-mime; name="smime.p7m"
Content-Description: smime.p7m
Content-Disposition: attachment; filename="smime.p7m"; size=5138;
	creation-date="Tue, 27 Feb 2024 16:08:00 GMT";
	modification-date="Wed, 14 Aug 2024 13:45:52 GMT"
Content-ID: <010EB631E9538B4C8307F087CA61A789@eurprd05.prod.outlook.com>
Content-Transfer-Encoding: base64

TUlBR0NTcUdTSWIzRFFFSEE2Q0FNSUFDQVFBeGdnSDRNSUlCOUFJQkFEQmNNRkF4Q3pBSkJnTlZC
QVlUQWtSRk1SWXdGQVlEVlFRSwpFdzFuTVRBZ1EyOWtaU0JIYldKSU1SSXdFQVlEVlFRTEV3bEhi
.......

--_002_2120949oMNUckLgytfedora_--
```

### Example S/MIME signed

```
From: Berta Boss <berta.boss@demo.gnupg.com>
To: Berta Boss <berta.boss@demo.gnupg.com>
Subject: Hello
Date: Tue, 27 Feb 2024 16:08:01 +0000
Content-Type: multipart/signed; boundary="nextPart2378062.iZASKD2KPV";
 micalg="sha256"; protocol="application/pkcs7-signature"
MIME-Version: 1.0


--nextPart2378062.iZASKD2KPV
Content-Transfer-Encoding: 7Bit
Content-Type: text/plain; charset="utf-8"

signed only smime
--nextPart2378062.iZASKD2KPV
Content-Type: application/pkcs7-signature; name="smime.p7s";
 smime-type="signed-data"
Content-Disposition: attachment; filename="smime.p7s"
Content-Transfer-Encoding: base64

MIIHPwYJKoZIhvcNAQcCoIIHMDCCBywCAQExDzANBglghkgBZQMEAgEFADALBgkqhkiG9w0BBwGg
ggRZMIIEVTCCAr2gAwIBAgIIPQ+rJvgsdA0wDQYJKoZIhvcNAQELBQAwUDELMAkGA1UEBhMCREUx
....


--nextPart2378062.iZASKD2KPV--
```
